/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.menu;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemItemStorages;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3917;
import slimeknights.mantle.inventory.SmartItemHandlerSlot;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.menu.ReadOnlySlot;

public class ToolContainerMenu
extends class_1703 {
    public static final int SLOT_SIZE = 18;
    public static final int REPEAT_BACKGROUND_START = 17;
    private final class_1799 stack;
    private final SlottedStackStorage itemHandler;
    private final class_1657 player;
    private final class_1304 slotType;
    private final int selectedHotbarSlot;
    private final boolean showOffhand;
    private final int playerInventoryStart;

    public ToolContainerMenu(int id, class_1661 playerInventory, class_1799 stack, SlottedStackStorage itemHandler, class_1304 slotType) {
        this((class_3917)TinkerTools.toolContainer.get(), id, playerInventory, stack, itemHandler, slotType);
    }

    public static ToolContainerMenu forClient(int id, class_1661 inventory, class_2540 buffer) {
        class_1304 slotType = (class_1304)buffer.method_10818(class_1304.class);
        class_1799 stack = inventory.field_7546.method_6118(slotType);
        SlottedStackStorage handler = Optional.ofNullable((Storage)ItemItemStorages.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack))).filter(cap -> cap instanceof SlottedStackStorage).orElse(null);
        return new ToolContainerMenu((class_3917)TinkerTools.toolContainer.get(), id, inventory, stack, handler, slotType);
    }

    protected ToolContainerMenu(@Nullable class_3917<?> type, int id, class_1661 playerInventory, class_1799 stack, SlottedStackStorage handler, class_1304 slotType) {
        super(type, id);
        int c;
        this.stack = stack;
        this.itemHandler = handler;
        this.player = playerInventory.field_7546;
        this.slotType = slotType;
        int slots = this.itemHandler.getSlotCount();
        for (int i = 0; i < slots; ++i) {
            this.method_7621((class_1735)new ToolContainerSlot(this.itemHandler, i, 8 + i % 9 * 18, 18 + i / 9 * 18));
        }
        this.showOffhand = ModifierUtil.checkVolatileFlag(stack, ToolInventoryCapability.INCLUDE_OFFHAND);
        if (this.showOffhand) {
            int x = 8 + slots % 9 * 18;
            int y = 18 + slots / 9 * 18;
            if (slotType == class_1304.field_6171) {
                this.method_7621(new ReadOnlySlot((class_1263)playerInventory, 40, x, y));
            } else {
                this.method_7621(new class_1735((class_1263)playerInventory, 40, x, y));
            }
            ++slots;
        }
        this.playerInventoryStart = this.field_7761.size();
        int playerY = 32 + 18 * ((slots + 8) / 9);
        for (int r = 0; r < 3; ++r) {
            for (c = 0; c < 9; ++c) {
                this.method_7621(new class_1735((class_1263)playerInventory, c + r * 9 + 9, 8 + c * 18, playerY + r * 18));
            }
        }
        int hotbarStart = playerY + 58;
        this.selectedHotbarSlot = slotType == class_1304.field_6173 ? playerInventory.field_7545 : (slotType == class_1304.field_6171 ? 10 : -1);
        for (c = 0; c < 9; ++c) {
            if (c == this.selectedHotbarSlot) {
                this.method_7621(new ReadOnlySlot((class_1263)playerInventory, c, 8 + c * 18, hotbarStart));
                continue;
            }
            this.method_7621(new class_1735((class_1263)playerInventory, c, 8 + c * 18, hotbarStart));
        }
    }

    public boolean method_7597(class_1657 playerIn) {
        return this.player == playerIn && !this.stack.method_7960() && this.player.method_6118(this.slotType) == this.stack;
    }

    public class_1799 method_7601(class_1657 playerIn, int index) {
        if (this.playerInventoryStart < 0) {
            return class_1799.field_8037;
        }
        class_1799 result = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            result = slotStack.method_7972();
            int end = this.field_7761.size();
            if (index < this.playerInventoryStart ? !this.method_7616(slotStack, this.playerInventoryStart, end, true) : !this.method_7616(slotStack, 0, this.playerInventoryStart, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return result;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public SlottedStackStorage getItemHandler() {
        return this.itemHandler;
    }

    public class_1304 getSlotType() {
        return this.slotType;
    }

    public int getSelectedHotbarSlot() {
        return this.selectedHotbarSlot;
    }

    public boolean isShowOffhand() {
        return this.showOffhand;
    }

    private static class ToolContainerSlot
    extends SmartItemHandlerSlot {
        private final int index;

        public ToolContainerSlot(SlottedStackStorage itemHandler, int index, int xPosition, int yPosition) {
            super((SlottedStorage)itemHandler, index, xPosition, yPosition);
            this.index = index;
        }

        public void method_7673(@Nonnull class_1799 stack) {
            ((SlottedStackStorage)this.getItemHandler()).setStackInSlot(this.index, stack);
        }

        public void method_7668() {
            this.method_7673(this.method_7677());
        }
    }
}

